SELECT *
FROM ##sales
WHERE quantity_sold is null

--Remove the rows
BEGIN TRANSACTION
	SELECT count(*) as nulls_before_deletion FROM ##sales
	WHERE quantity_sold is null
	DELETE ##sales
	WHERE quantity_sold is null
	SELECT count(*)  as nulls_after_deletion FROM ##sales
	WHERE quantity_sold is null
ROLLBACK TRANSACTION

--Set the values to 0
BEGIN TRANSACTION
	SELECT count(*) as zeros_before_update FROM ##sales WHERE quantity_sold =0
	UPDATE ##sales
	SET quantity_sold =0
	WHERE quantity_sold is null
	SELECT count(*) as zeros_after_update FROM ##sales WHERE quantity_sold =0
ROLLBACK TRANSACTION

--Set the values to a suitable default value (e.g. quantity sold was likely 1)
BEGIN TRANSACTION
	SELECT count(*) as ones_before_update FROM ##sales WHERE quantity_sold =1
	UPDATE ##sales
	SET quantity_sold =1
	WHERE quantity_sold is null
	SELECT count(*) as ones_after_update FROM ##sales WHERE quantity_sold =1
ROLLBACK TRANSACTION